const { app, BrowserWindow, ipcMain, shell } = require('electron');
const os = require('os');
const path = require('path');
const http = require('http');
const dirTree = require("directory-tree");
const { spawn } = require('child_process');
const fs = require('fs');
const https = require('https');
const axios = require('axios');
const FormData = require('form-data');
const url = require('url');

function makeid(length) {
  var result           = [];
  var characters       = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
  var charactersLength = characters.length;
  for ( var i = 0; i < length; i++ ) {
    result.push(characters.charAt(Math.floor(Math.random() * charactersLength)));
 }
 return result.join('');
}

const VERIFY_TOKEN = makeid(32);
let mainWindow;
let activePort;

function createWindow () {
  mainWindow = new BrowserWindow({
    width: 800,
    height: 600,
    minWidth: 666,
    minHeight: 500,
    webPreferences: {
      preload: path.join(__dirname, 'preload.js')
    }
  })
  mainWindow.loadFile('public/index.html')
}

function getWatchFolderPath() {
  return path.join(os.homedir(), 'Pictures');
}

app.on('activate', () => {
  if (BrowserWindow.getAllWindows().length === 0) {
    createWindow()
  }
});

app.on('window-all-closed', () => {
  if (process.platform !== 'darwin') {
    app.quit()
  }
});

// Communicate with renderer
ipcMain.on('main.openFacebookInBrowser', (_event) => {
  if (!activePort) {
    console.log("Attempted to open Facebook but there's no active port")
  };

  let facebookURL = 'https://www.facebook.com/v10.0/dialog/oauth?client_id=435007874376081&scope=pages_show_list,instagram_basic,instagram_content_publish,pages_read_engagement&response_type=token&redirect_uri=https://www.socialbeam.us/facebook';
  facebookURL += `&state=${encodeURIComponent(JSON.stringify({ active_port: activePort, verify_token: VERIFY_TOKEN }))}`;
  shell.openExternal(facebookURL);
});

// Communicate with renderer
ipcMain.on('main.openPrivacyPolicy', (_event) => {
  shell.openExternal('https://www.socialbeam.us/privacy');
});

ipcMain.on('main.openWatchFolder', (_event) => {
  console.log('opening watch folder');
  const open = spawn('open', [getWatchFolderPath()]);

  open.stdout.on('data', (data) => {
    console.log(`stdout: ${data}`);
  });

  open.stderr.on('data', (data) => {
    console.log(`stderr: ${data}`);
  });

  open.on('close', (code) => {
    console.log(`child process exited with code ${code}`);
  });
});

let gettingFiles = false;

ipcMain.on('main.getImages', (_event) => {
  if (gettingFiles) return;
  gettingFiles = true;

  try {
    const tree = dirTree(getWatchFolderPath(), { attributes:['mtime'] });
    mainWindow.webContents.send('renderer.sendMessage', { type: 'renderer.setImages', payload: tree });
  } catch (err) {
    console.error(err)
  } finally {
    setTimeout(() => gettingFiles = false, 500);
  }
});

ipcMain.on('main.uploadToS3', async (_event, targetImageName) => {
  try {
    const { url: uploadURL } = await getUploadURL();
    const filePath = path.join(getWatchFolderPath(), targetImageName);
    const status = await uploadToS3(uploadURL, filePath);

    if (status != 200) {
      mainWindow.webContents.send('renderer.sendMessage', { type: 'renderer.setDownloadURL', payload: { status, downloadURL: null }});
      return;
    }
    
    const { origin, pathname } = new URL(uploadURL);
    const downloadURL = origin + pathname;

    mainWindow.webContents.send('renderer.sendMessage', { type: 'renderer.setDownloadURL', payload: { status, downloadURL }});
    console.log('Successfully uploaded file', downloadURL);
  } catch (err) {
    console.log('Failed to upload file:', err);
  }

});

app.whenReady().then(() => {
  http.createServer((req, res) => {
    const origin = 'https://www.socialbeam.us';
    const { pathname, searchParams } = new URL(`${origin}${req.url}`);

    res.setHeader('Access-Control-Allow-Origin', origin);

    if (pathname === '/auth/facebook') {
      const accessToken = searchParams.get('access_token');
      const verifyToken = searchParams.get('verify_token');

      if (verifyToken !== VERIFY_TOKEN) {
        res.writeHead(401, { 'Content-Type': 'application/json' });
        res.write(JSON.stringify({ error: { detail: 'Invalid verification token' }}));
        res.end();
      } else if (accessToken) {
        mainWindow.webContents.send('renderer.sendMessage', { type: 'renderer.setAccessToken', payload: accessToken });
        res.writeHead(204);
        res.end();
      } else {
        res.writeHead(400, { 'Content-Type': 'application/json' });
        res.write(JSON.stringify({ error: { detail: 'Missing access token' }}));
        res.end();
      }
    } else {
      res.writeHead(404);
      res.end();
    }
  }).listen(0, function() {
    activePort = this.address().port;
    console.timeEnd('server');
    console.log(`server started at port ${activePort}`);

    createWindow()
  });
});

function getUploadURL() {
  const options = {
    'method': 'POST',
    'hostname': 'photo-beam.herokuapp.com',
    'path': '/uploads'
  };

  return new Promise((resolve, reject) => {
    const req = https.request(options, (res) => {
      var chunks = [];

      res.on("data", (chunk) => {
        chunks.push(chunk);
      });

      res.on("end", (chunk) => {
        var body = Buffer.concat(chunks);
        resolve(JSON.parse(body));
      });

      res.on("error", (error) => {
        reject(error);
      });
    });

    req.end();
  });
}

function uploadToS3(uploadURL, filePath) {
  return new Promise((resolve, reject) => {
    const data = fs.readFileSync(filePath);

    var config = {
      method: 'put',
      url: uploadURL,
      headers: { 
        'Content-Type': 'image/jpeg'
      },
      data : data
    };
    
    axios(config)
    .then(function (response) {
      resolve(response.status);
    })
    .catch(function (error) {
      reject(error);
    });
  });
}
