const { contextBridge, ipcRenderer} = require('electron')

contextBridge.exposeInMainWorld(
  'electron',
  {
    on: (eventName, callback) => ipcRenderer.on(eventName, callback),
    send: (eventName, eventData) => ipcRenderer.send(eventName, eventData),
    removeListener: (eventName, listener) => ipcRenderer.removeListener(eventName, listener)
  }
)
