(() => {
  const http = require('http');

  console.time('server');
  let activePort = null;

  window.addEventListener('getActivePort', () => {
    const event = new CustomEvent('setActivePort', { detail: { activePort }});
    window.dispatchEvent(event);
  });

  function sendAccessTokenToPanel(provider, accessToken) {
    const eventType = `client.${provider}.setAccessToken`;
    const payload = { accessToken };
    window.postMessage({ type: eventType, payload }, '*');
    console.log(`Sent ${eventType} to client with payload:`, payload);
  }

  http.createServer(function (req, res) {
    const origin = 'https://www.socialbeam.us';
    const { pathname, searchParams } = new URL(`${origin}${req.url}`);

    res.setHeader('Access-Control-Allow-Origin', origin);

    if (pathname === '/auth/facebook' || pathname === '/auth/google') {
      const accessToken = searchParams.get('access_token');
      const provider = pathname.split('/').pop();

      if (accessToken) {
        sendAccessTokenToPanel(provider, accessToken);
        res.writeHead(204);
        res.end();
      } else {
        res.writeHead(400, { 'Content-Type': 'application/json' });
        res.write(JSON.stringify({ error: { detail: 'Missing access token' }}));
        res.end();
      }
    } else {
      res.writeHead(404);
      res.end();
    }
  }).listen(0, function() {
    activePort = this.address().port;
    console.timeEnd('server');
    console.log(`server started at port ${activePort}`);
  });
})();
